#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright 2006 Derek Land (derek@ddmr.nl)
# This file is part of PyTrinet.

# PyTrinet is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PyTrinet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import Numeric as n
import sys
import matplotlib
from matplotlib import use as setbackend
import os
#from pylab import *

setbackend("Agg")

import pylab
# dictionary for looking up the coordinates of a column of a players field
columns = {
	chr(ord('3')):0,
	chr(ord('3')+1):1,
	chr(ord('3')+2):2,
	chr(ord('3')+3):3,
	chr(ord('3')+4):4,
	chr(ord('3')+5):5,
	chr(ord('3')+6):6,
	chr(ord('3')+7):7,
	chr(ord('3')+8):8,
	chr(ord('3')+9):9,
	chr(ord('3')+10):10,
	chr(ord('3')+11):11
}
# dictionary for looking up the coordinates of a row of a players field
rows = {
	chr(ord('H')-21):0,
	chr(ord('H')-20):1,
	chr(ord('H')-19):2,
	chr(ord('H')-18):3,
	chr(ord('H')-17):4,
	chr(ord('H')-16):5,
	chr(ord('H')-15):6,
	chr(ord('H')-14):7,
	chr(ord('H')-13):8,
	chr(ord('H')-12):9,
	chr(ord('H')-11):10,
	chr(ord('H')-10):11,
	chr(ord('H')-9):12,
	chr(ord('H')-8):13,
	chr(ord('H')-7):14,
	chr(ord('H')-6):15,
	chr(ord('H')-5):16,
	chr(ord('H')-4):17,
	chr(ord('H')-3):18,
	chr(ord('H')-2):19,
	chr(ord('H')-1):20,
	chr(ord('H')):21
}
# ascii codecs of the blocks used by the client
blocks = {
	'!':0.1, # holes, black
	'"':0.2, # blue, left Z, |
	'#':0.3, # yellow (square, _|_) 
	'$':0.4, # green, left L
	'%':0.5, # purple, L
	'&':0.6, # red, Z
	"'":0.71, 
	'(':0.72,
	')':0.73,
	'*':0.74,
	'+':0.75,
	',':0.76,
	'-':0.78,
	'.':0.79,
	'/':0.80
}

cdict = {
		'red':((0.0, 0.0, 0.0),
		(0.1, 0., 0.),
		(0.2, 0., 0.),
		(0.3, 1., 1.),
		(0.4, 0., 0.),
		(0.5, 160./255, 160./255),
		(0.6, 1.0, 1.0),
		(0.7, 1.0, 1.0),
		(1.0, 0.1, 0.1)),
		'green':((0.0, 0.0, 0.0),
		(0.1, 0., 0.),
		(0.2, 0., 0.),
		(0.3, 1., 1.),
		(0.4, 1., 1.),
		(0.5, 32./255, 32./255),
		(0.6, 0.0, 0.0),
		(0.7, 1.0, 1.0),
		(1.0, 1.0, 1.0)),
		'blue':((0.0, 0.0, 0.0),
		(0.1, 0., 0.),
		(0.2, 1., 1.),
		(.3, 0., 0.),
		(0.4, 0., 0.),
		(0.5, 240./255, 240./255),
		(0.6, 0.0, 0.0),
		(0.7, 1.0, 1.0),
		(1.0, 1.0, 1.0)),
}

def read_string():
	#use one fixed string instead...
	data = '''<Server> 000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000Z$3G3H4H5HZ$6G6H7H8HZ&8G9G9H:HZ#;G<G;H<HZ"9E9F:F:GZ">E>F>G>HZ&8E7F8F7GZ$<D<E;F<FZ"5F6F4G5GZ"4E5E3F4FZ#:D;D:E;EZ&5D6D6E7EZ#3C3D4D3EZ#8C7D8D9DZ%7B5C6C7CZ!7B3C5C6C7C8C3D4D5D6D7D8D9D:D;D<D3E4E5E6E7E8E9E:E;E<E>E3F4F5F6F8F9F:F;F<F>F4G9G:G;G<G
<Server> >G>H#3G8G3H4H7H8H:H%7F5G&5H6H(6G<H/7G9HZ!7F3G5G6G8G4H9H:H;H<H#>H%7G5H(6H,=H/7HZ#9G:G9H:HZ#;G<G;H<HZ$6E6F5G6GZ!5H"6H;H#9F:F;F<F3G8G>G4H=H$6D5F3H7H:H>H%7F5G8H&9H<H(6G,=G/7GZ&<E=E=F>FZ#:D;D:E;EZ!6D;GZ$4E5E4F4GZ#5C6C5D6DZ"7D7E8E8FZ#<C=C<D=DZ">B>C>D>EZ#:B;B:C;CZ"8C8D9D9EZ!:B;B>B5C6C8C:C;C<C=C>C5D6D7D8D9D:D;D<D=D>D4E5E6E7E8E9E<E=E4F7F9F">F#5F6F=F'<F,7H/>GZ"3C3D3E3FZ&5D4E5E4FZ&5B4C5C4DZ!;F5G<H"3B>D8E6G;G#:D;D5E6E=E3F8F9F<F4G=G7H>H$4F3G:G>G%5F8G3H4H9H&5A4B9G<G5H6H=H'<E(6F,=F7G/7F>FZ%<B<C<D=DZ&8C7D8D7EZ!
		#os.system('cp '+ basename +' /net/virgo01/data/users/derek/')
<Server> 5A3B4B<B8C7D:D;D=D>D6E"9C9D9E%<E=E&5E8E/7HZ!7E8E:E=E>E6F7F8F=F>F6G7G8G=G>G6H7H8H"6C3H#9=<@$<F%=;7>>@&5<8A:D(5:,5C9DZ!5:=;5<9=7><@>@8A6C8D:D;E5F<G"3B6B9B9D;F3G4H9H#9<<?;D3E9E:E4F>G7H<H$4E<E3F:F6H=H%=:7=>?<B5E4G9G&5;8@5A4B5C8C:C9F<F5G=G;H>H(59,5B9CZ&;@:A;A:BZ%=9>9>:>;Z":=:>;>;?Z$:<;<<<<=Z#6;7;6<7<Z#;:<:;;<;Z"8<8=8>8?Z&7:8:8;9;Z"4>4?4@4AZ"3;3<4<4=Z!59=:5;>;3<6<9<;<7=<=:><?>?8@;A6B8C:C;D5E<F9H"3:4;8;:<;=3A6A9A9C;E3F4G9G6H8H<H#;9<96:7:9;<>;C3D9D:D4E>F7G<G4H=H$:;;;<;4D<D3E:E6G=G7H>H%=8>87<>><A5D4F9F5H
<Server> ;H&79895:9:8?;?5@:@4A5B8B9E<E5F=F;G>G:H(58,5A9BZ$:8;8:9::Z"3839494:Z&=6<7=7<8Z"36374748Z$78889899Z%=5>5>6>7Z!=5>53647<7788898:8;8%=6586869&=8,=FZ#77877888Z!=6>6377787485868<899:9;95:;=<>>>5@:@3A6A9A<A8B;C:D;E5F=F>F6G7G<G8H"3<:>8?;?4A6B9B3D9D;G4H9H#7989;;<;6<7<9<<?;D3E9E:E4F>G7H<H$9::<;<<=4E<E3F6H:H=H%=7596:=:>;7=>?<D5E4G9G&<9=97:5;8;9;8@5A;A8C:C4D5D9F<F5H;H>H,5B9C=GZ!=7>7387888495969<99:::;:5;;><?>?5A:A3B6B9B<B8C;D:E;F5G=G>G6H7H<H"3=:?8@;@4B6C9C3E9E;H#7:8:;<<<6=7=9=<@;E3F9F:F4G>H$9;:=;=<>4F<F3G%
<Server> =85:6;=;><7>>@<E5F4H9H&<:=:7;5<8<9<8A5B;B8D:D4E5E9G<G,5C9D=HZ!=83;4<;<9=5B4DZ!>8397989=94:5:6:<:%;:/7=Z#4:5:6:5;Z!4;4>8@;@9DZ#;9<9=9<:Z#=7<8=8>8Z!=7<8>8;93:4:5:6:7:8:#>99:::;:=:(8?Z%896:7:8:Z&889899:9Z!8898=8:9<9>96:7:;:5;"3;4<#>:9;:;=;%7;8;&899:::'<:Z#:9;9<9;:Z!;;=;5<9<><3=4=6=;=7><>8?:?;?<@>@8A;B4C6C9C8D:D;E5F<G;H"3:4;8<:=4>;>3B6B9B9D;F3G4H6H9H:H#:8;8<8=8>99:::<:6;7;<?;D3E9E:E4F>G5H$:;;<<<4E<E3F:F3H7H<H%896:7:>:7=>?<B5E4G9G8H&8898:95;8;9;8@;@:A4B5C8C4D9F<F5G=H'<9(8>,5B=G/7<Z%5969795:Z!8898:8;8
<Server> <8=85969798999:9;9<9=9>93:5:6:7:>:#4:&8:9:'5E(4EZ!::6<5B3HZ#59695:6:Z%7989997:Z!;:=:5;6;9;>;3<4<;<7=<=8>:>;><?>?8@;A4B6B9B8C:C;D5E<F3G;G<H"3:4:8;:<4=;=3A6A9A9C;E3F4G6G9G:G;H#586849;9<9=97:<>;C3D9D:D4E>F5G3H:H$::;;<;<D3E:E7G<G9H%788898>:7<>><A4F9F8G6H7H&89995:8?;?:@4A5B8B4C9E<E5F=G5H8H'5D(8=4D,=F/7;Z#37384839Z#>7=8>8>9Z!37>738485868788898=8>8495969798999;9<9=9*6G/8<Z&38484959Z!5:6:9:>:3;4;;;7<<<8=:=;=<>>>8?;@4A6A9A8B:B;C5D<E3F;F<G>H"39498::;4<;<3@6@9@9B;D3E4F9F:F;G5H#38>86979<9<=;B3C9C:C4D>E5F3G:
<Server> G$:9;:<:<C3D:D7F<F9G6H;H<H%>97;>=<@4E9E8F6G7G8H=H&37475889998>;>:?4@5A8A4B9D<D5E=F5G8G3H7H9H:H'5C(8<4C*6F,=E/7:8;Z":7:8;8;9Z"7:#6F%8;8<5C&4C=EZ!3747:758;8>869798999":9#=839=9>9&3849*4=Z$69796:6;Z!3848:8=8596979;9<9>9"9:&39'89Z">9>:>;><Z$894=Z&:8;8;9<9Z#5859695:Z$<7<8=8>8Z"67687879Z!67<75878:8;8=8>83949"69#988999$<9=9>9&:9,>FZ!=93:4:5:9:;:6;7;<;8<:<;<<=>=8>;?4@6@9@8A:A;B5C<D3E;E<F>G4H"677839498999>9::4;;;4=3?6?9?9A;C3D4E9E:E;F5G6H;H>H#975888<<;A3B9B:B4C>D5E6E3F:F>F3H$<7=8>869:9;94<<B3C:C7E<E9F6G;
<Server> G<G5H:H%7:8:><<?5B4D9D8E6F7F8G=G9H&:8;88=;=:>4?5@8@4A9C<C5D=D5F8F3G7G9G:G,>EZ"35363738Z!356797<77888:8;8=8>8&574858*><Z"87977888Z!36578797486878<8:9;9"9869#=899=9>9&4959*>FZ&57676878Z00000000000000000000000000000000000010550000000010555110002015511120032200034401030101000401100103000000020r01000500500001000005500015010015040010500505040015500010240025400022030032000053150014500043105201223411035b21544532105r511354553340203154431341551414123505Z$;7<7;8;9Z!=7884=9C;C4DZ%35454647Z":5:6:7:8Z"6465757
<Server> 6Z00010000000044011001000014551001000014555111330015511021332200034401330101000401100103000000020r01000500500000000005500015010015040010500505040015500010240025400022030032000053150014500003005200223411035b21544532105r511354553340203154431341551414123505143423044552Z"93:38494Z!93:335:5366878;84;8;;;:<;<3>5>8>:><>3?9?;?5@:@<@9C=C>C:D=D>D"33734585;546;6<83;4?:?7C8C9D#<?8@3C4C8D$=688=8>8;@5C:C7D%555698:8;>=?4@6C4D5D&75867;:;<<=<4>7>9>6?3@;C3D6D;D*<D,<CZ1423233215531225554534332225223355122443331452
<Server> 35214552214451533524232555314231152541211551143434242442312235234332443442451233142335451123531313542331525542341513553554252233532154241144312453142432352424112221135143523253411154224315215332435343145455145245511331Z
<Server>'''
	return data

def parse_data(raw_data):
	data1 = raw_data.replace('\r\n', '')
	data2 = data1.replace('<Server>', '') 
	data3 = data2.replace('r', '')
	data = data3.replace(' ','')
	data.strip()
	parts = data.split('Z')
	field = []
	current_field = n.zeros((22,12),typecode='float')
	k = 0
	pid = os.getpid()
	basename = 'pytrinet_' + str(pid) + '_'
	for part in parts:
		i = 0; j = 0; blocktype = 0
		row = 0;  cols = 0; col = 0
		if part == '':
			break
		if (ord(part[0]) < 33) or (ord(part[0]) > 47):
			for letter in part:
				if cols > 11:
					col = 0
					cols = 0
					row += 1
				if not letter.isdigit():	
					letter = 0
				if int(letter) > 0:
					current_field[row][col] = (float(letter) + 1)/10.
				else:
			  		current_field[row][col] = float(letter)
				cols += 1
				col += 1
		else:
			while i < len(part):
				if (ord(part[i]) >= 33) and (ord(part[i]) <= 47):
					blocktype = blocks[part[i]]
					i += 1
				col = columns[part[i]]
				row = rows[part[i+1]]
				current_field[row][col] = blocktype
				i += 2
		if k <= 9999:
			if k <= 999:
				if k <= 99:
					if k <= 9:
						ks= '000' + str(k)
					else:	
						ks = '00' + str(k)
				else:
					ks = '0' + str(k)
			else:
				ks = str(k)
		else:
			ks = str(k)
		name = basename + ks
		create_image(current_field, name)
		k += 1
	create_animated(basename)	
	return '/tmp/'+basename+'.gif'

def create_image(field, image_name):
	my_cmap = matplotlib.colors.LinearSegmentedColormap('my_colormap', cdict, 256)
	pylab.figure(figsize=(6.0,10.5))
	pylab.xticks(pylab.arange(12), ['' for i in range(12)])
	pylab.yticks(pylab.array([0,22]), ['' for i in range(22)])
	pylab.grid(1)
	pylab.imshow(field, cmap=my_cmap,vmin=0., vmax=1., interpolation='nearest')#, aspect='preserve')
	pylab.savefig('/tmp/'+image_name+'.png')

def create_animated(basename, delay=50):
	command = "convert -size 300x575 -limit memory 64 -limit map 128 -delay " + str(delay) + " -loop 0 /tmp/" + basename + "*.png -resize 300x575 " + "/tmp/" + basename + ".gif"
	os.system(command)
	os.system("rm -f /tmp/" + basename + "*.png")

def print_field(fields):
	for i in range(len(fields)):
		print '%3s %s' %(i, fields[i])

if __name__ == '__main__':
	data = read_string()
	filename = parse_data(data)
			
			
				
	
